<?php

namespace Mtc\Crm\Tests\Unit;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Models\EnquiryTag;
use Mtc\Crm\Tests\TestCase;

class EnquiryTagTest extends TestCase
{
    use RefreshDatabase;


    public function testGetTags()
    {
        $type = EnquiryTag::query()->create([ 'name' => 'hello' ]);
        $type2 = EnquiryTag::query()->create([ 'name' => 'world' ]);

        $this->assertEquals(2, EnquiryData::getTags()->count());
        $this->assertTrue(EnquiryData::getTags()->first()->is($type));
    }

    public function testFindTag()
    {
        $type = EnquiryTag::query()->create([ 'name' => 'hello' ]);

        $this->assertTrue(EnquiryData::findTag($type->id)->is($type));

        $this->expectException(ModelNotFoundException::class);
        EnquiryData::findTag(PHP_INT_MAX);
    }

    public function testAddTag()
    {
        EnquiryData::addTag('hello-world');
        $this->assertTrue(EnquiryTag::query()->where('name', 'hello-world')->exists());
    }

    public function testUpdateTag()
    {
        $tag = EnquiryData::addTag('hello-world');
        $this->assertTrue(EnquiryTag::query()->where('name', 'hello-world')->exists());
        EnquiryData::updateTag($tag->id, 'lorem-ipsum');
        $this->assertTrue(EnquiryTag::query()->where('name', 'lorem-ipsum')->where('id', $tag->id)->exists());
    }

    public function testRemoveTag()
    {
        $tag = EnquiryData::addTag('hello-world');
        $this->assertTrue(EnquiryTag::query()->where('name', 'hello-world')->exists());
        $this->assertTrue(EnquiryData::removeTag($tag->id));
        $this->expectException(ModelNotFoundException::class);
        EnquiryData::findTag($tag->id);
    }
}
