<?php

namespace Mtc\Crm\Tests\Unit;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Models\Enquiry;
use Mtc\Crm\Models\EnquiryAction;
use Mtc\Crm\Models\EnquiryMessage;
use Mtc\Crm\Models\EnquiryStatus;
use Mtc\Crm\Models\EnquiryStatusHistory;
use Mtc\Crm\Models\EnquiryTag;
use Mtc\Crm\Models\EnquiryType;
use Mtc\Crm\Models\Form;
use Mtc\Crm\Models\FormAction;
use Mtc\Crm\Models\FormQuestion;
use Mtc\Crm\Models\FormSection;
use Mtc\Crm\Tests\TestCase;

class ModelRelationshipTest extends TestCase
{
    use RefreshDatabase;

    public function test_enquiry_relationships()
    {
        $tag = EnquiryTag::factory()->create();
        $type = EnquiryType::factory()->create();
        $status = EnquiryStatus::factory()->create();
        $enquiry = Enquiry::factory()->create([
            'status_id' => $status->id,
            'type_id' => $type->id,
        ]);
        $action = EnquiryAction::factory()->create(['enquiry_id' => $enquiry->id]);
        $message = EnquiryMessage::factory()->create([
            'enquiry_id' => $enquiry->id,
            'new_status_id' => $status->id,
        ]);

        $enquiry->tags()->attach($tag);


        $status_history = EnquiryStatusHistory::factory()->create();

        $this->assertTrue($enquiry->is($action->enquiry));
        $this->assertTrue($type->is($enquiry->type));

        $this->assertTrue($enquiry->is($message->enquiry));
        $this->assertTrue($status->is($message->status));

        $this->assertTrue($enquiry->is($status_history->enquiry));
        $this->assertTrue($status->is($status_history->status));


        $enquiry->update([
            'reason_id' => $type->id,
            'reason_type' => $type->getMorphClass(),
            'submitter_id' => $status->id,
            'submitter_type' => $status->getMorphClass(),
        ]);

        $this->assertTrue($status->is($enquiry->submitter));
        $this->assertTrue($type->is($enquiry->reason));


        $this->assertEquals(1, $status->enquiries()->count());
        $this->assertEquals(1, $tag->enquiries()->count());
        $this->assertEquals(1, $type->enquiries()->count());
    }

    public function test_form_relationships()
    {
        $form = Form::factory()->create();
        $section = FormSection::factory()->create(['form_id' => $form->id]);
        $action = FormAction::factory()->create(['form_id' => $form->id]);
        $question = FormQuestion::factory()->create([
            'form_id' => $form->id,
            'form_section_id' => $section->id,
        ]);

        $this->assertTrue($form->is($section->form));
        $this->assertTrue($form->is($question->form));
        $this->assertTrue($form->is($action->form));
        $this->assertTrue($section->is($question->section));

        $this->assertEquals(1, $form->sections()->count());
        $this->assertEquals(1, $form->questions()->count());
        $this->assertEquals(1, $section->questions()->count());
    }
}
