<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gp_addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('nhs_organisation_id')
                ->constrained()
                ->cascadeOnDelete();
            $table->string('uprn')->nullable();
            $table->string('address_line_1')->nullable();
            $table->string('address_line_2')->nullable();
            $table->string('town')->nullable();
            $table->string('county')->nullable();
            $table->string('postcode')->nullable();
            $table->string('country')->nullable();
            $table->timestamps();

            // Unique index to prevent duplicates (small subset, avoids key too long)
            $table->unique(['nhs_organisation_id', 'address_line_1', 'postcode'], 'nhs_address_unique');

            // Full-text indexes for searching
            $table->fullText(['address_line_1', 'address_line_2'], 'address_full_text_index');
            $table->fullText(['town', 'county', 'postcode', 'country'], 'location_full_text_index');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gp_addresses');
    }
};
