<?php

use Illuminate\Support\Facades\Route;
use Mtc\GpAddresses\Http\Controllers\GpAddressesController;

// Admin routes (authenticated)
Route::group([
    'prefix' => 'admin',
    'middleware' => 'auth',
], function () {
    Route::group([
        'prefix' => 'gp-addresses',
    ], function() {
        Route::get('/', [GpAddressesController::class, 'index'])->name('gpaddresses.index');
        Route::get('/fetch', [GpAddressesController::class, 'fetch'])->name('gpaddresses.fetch');
    });
});

// Customer-facing API routes (public)
Route::group([
    'prefix' => 'api/gp-addresses',
], function () {
    Route::get('/search', [GpAddressesController::class, 'search'])->name('gpaddresses.search');
    Route::get('/search-by-postcode', [GpAddressesController::class, 'searchByPostcode'])->name('gpaddresses.search-by-postcode');
    Route::get('/{id}', [GpAddressesController::class, 'show'])->name('gpaddresses.show');
});
