<?php

namespace Mtc\GpAddresses\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class GpPracticeResource extends JsonResource
{
    public function toArray($request)
    {
        $address = $this->whenLoaded('address');
        $contact = $this->whenLoaded('contact');

        return [
            'id' => $this->id,
            'name' => $this->name,
            'org_id' => $this->org_id,
            'status' => $this->status,
            'address_line_1' => $address?->address_line_1 ?? '',
            'address_line_2' => $address?->address_line_2 ?? '',
            'town' => $address?->town ?? '',
            'county' => $address?->county ?? '',
            'postcode' => $address?->postcode ?? '',
            'country' => $address?->country ?? '',
            'telephone_number' => $contact?->telephone_number ?? '',
        ];
    }
}
