<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Mtc\Members\Member;
use Faker\Generator as Faker;

$factory->define(Member::class, function (Faker $faker) {
    return [
        'name' => $faker->name,
        'email'=> $faker->safeEmail,
        'contact_no' => random_int(0, 1) ? $faker->phoneNumber : null,
        'password' => \Illuminate\Support\Str::random(),
    ];
});

$factory->afterCreating(Member::class, function (Member $member, $faker) {
    $member->addresses()->saveMany(factory(\Mtc\Members\MemberAddress::class, random_int(0, 3))->make());
    $main_address = $member->addresses()->first();
    if ($main_address) {
        $member->default_address_id = $main_address->id;
        $member->save();
    }
});
