<?php

use Mtc\Members\Http\Controllers\Admin\MemberAddressController;
use Mtc\Members\Http\Middleware\LoggedInMember;
use Mtc\Members\Http\Middleware\NotAMember;
use Mtc\Members\Http\Controllers\DashboardController;
use Mtc\Members\Http\Controllers\AddressController;
use Mtc\Members\Http\Controllers\DetailController;
use Mtc\Members\Http\Controllers\Admin\MemberController;
use Mtc\Members\Http\Controllers\Auth\LoginController;
use Mtc\Members\Http\Controllers\Auth\ForgotPasswordController;
use Mtc\Members\Http\Controllers\Auth\ResetPasswordController;
use Mtc\Members\Http\Controllers\Auth\RegisterController;
use Mtc\Members\Http\Controllers\Admin\RoleController;


use Illuminate\Routing\Router;
/** @var Router $router */

$router->group([
    'prefix' => '/members/',
    'as' => 'members.',
], function (Router $router) {

    $router->group([
        'middleware' => [
            NotAMember::class
        ]
    ], function (Router $router) {
        $router->get('login', [config('members.auth_controllers.login'), 'showLoginForm'])->name('login');
        $router->post('login', [config('members.auth_controllers.login'), 'login'])->name('do-login');
        $router->get('register', [config('members.auth_controllers.register'), 'showRegistrationForm'])->name('register');
        $router->post('register', [config('members.auth_controllers.register'), 'register'])->name('do-register');
        $router->get('forgot-password', [config('members.auth_controllers.forgot_password'), 'show'])->name('password.request');
        $router->post('forgot-password', [config('members.auth_controllers.forgot_password'), 'send'])->name('password.send_reset');
        $router->get('reset-password', [config('members.auth_controllers.reset_password'), 'show'])->name('password.show_reset');
        $router->post('reset-password', [config('members.auth_controllers.reset_password'), 'reset'])->name('password.reset');
    });

    $router->group([
        'middleware' => [
            LoggedInMember::class
        ]
    ], function (Router $router) {

        $router->get('', [config('members.customer_controllers.dashboard'), 'index'])->name('dashboard');
        $router->get('logout', [config('members.auth_controllers.login'), 'logout'])->name('logout');
        $router->get('details', [config('members.customer_controllers.details'), 'show'])->name('view-details');
        $router->put('details', [config('members.customer_controllers.details'), 'update'])->name('save-details');
        $router->put('addresses/{address}/set-default', [config('members.customer_controllers.address'), 'setDefault'])->name('addresses.set-default');
        $router->resource('addresses', config('members.customer_controllers.address'));
    });
});


/** @var Router $router */
$router->group([
    'prefix' => '/admin/',
    'as' => 'admin.',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {

    if (config('members.member_roles')) {
        $router->resource('members/roles', RoleController::class);
    }
    $router->any('members/login-as/{member}', [MemberController::class, 'loginAs'])->name('members.login-as');
    $router->resource('members', MemberController::class);

    $router->group([
        'as' => 'members.',
    ], function (Router $router) {
        $router->put('members/{member}/addresses/{address}/set-default', [MemberAddressController::class, 'setDefault'])->name('addresses.set-default');
        $router->resource('members/{member}/addresses', MemberAddressController::class);
    });

});
