<?php

namespace Mtc\Members\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterById
 *
 * @package Mtc\Orders\Filters
 */
class FilterByName implements AdminFilter
{
    /**
     * Constant for input field name
     */
    const INPUT_FIELD_NAME = 'name';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'text',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Name',
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        return $query->where('name', 'like', '%' . $request->input(self::INPUT_FIELD_NAME) . '%');
    }
}
