<?php

namespace Mtc\Members;

use Illuminate\Support\Facades\Event;
use Mtc\Members\Events\LoadMembersAreaSections;

trait HasMembersNavigation
{
    public function sections()
    {

        return collect(Event::dispatch(LoadMembersAreaSections::class))
            ->filter()
            ->prepend([
                'route' => route('members.addresses.index'),
                'icon' => 'fas fa-map-marker',
                'name' => 'Address Book',
                'button_name' => 'View Now',
            ])
            ->prepend([
                'route' => route('members.view-details'),
                'icon' => 'fas fa-user',
                'name' => 'Account Details',
                'button_name' => 'Edit Now',
            ])
            ->prepend([
                'route' => route('members.dashboard'),
                'skip_dashboard' => true,
                'name' => 'Dashboard',
            ])
            ->push([
                'route' => route('members.logout'),
                'icon' => 'fas fa-sign-out',
                'name' => 'Logout',
                'button_name' => 'Logout',
            ]);
    }
}
