<?php

namespace Mtc\Members\Http\Middleware;

use Closure;
use Illuminate\Auth\Middleware\Authenticate;
use Mtc\Members\Facades\MemberAuth;

/**
 * Class LoggedInMember
 *
 * @package Mtc\Members\Http\Middleware
 */
class LoggedInMember extends Authenticate
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next, ...$guards)
    {
        if (MemberAuth::check() === true) {
            return $next($request);
        }

        return redirect(route('members.login'));
    }
}
