<?php

namespace Mtc\Members;

use Illuminate\Database\Eloquent\Model;
use Mtc\Foundation\Country;

/**
 * Class MemberAddress
 *
 * @package Mtc\Members
 */
class MemberAddress extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'member_addresses';

    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'member_id',
        'name',
        'first_name',
        'last_name',
        'address1',
        'address2',
        'city',
        'postcode',
        'country_code',
        // Additional fields for optional usage
        'address3',
        'state',
        'county',
    ];

    /**
     * Relationship to owner of this address
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function member()
    {
        return $this->belongsTo(Member::class);
    }

    /**
     * Relationship with country
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country()
    {
        return $this->belongsTo(Country::class, 'country_code', 'code');
    }

    /**
     * Get the country name
     *
     * @return string
     */
    public function getCountryNameAttribute()
    {
        return $this->country->name ?? '';
    }

    /**
     * route_hash attribute for masking id on front-end
     *
     * @return string
     */
    public function getRouteHashAttribute()
    {
        return base64_encode($this->id);
    }
}
