<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reservations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->index();
            $table->foreignId('customer_id')->nullable()->index();
            $table->string('reference')->index();
            $table->string('status')->index();
            $table->decimal('amount', 12)->nullable();
            $table->decimal('amount_ex_vat', 12)->nullable();
            $table->decimal('vat_value', 12)->nullable();
            $table->decimal('amount_in_currency', 12)->nullable();
            $table->string('currency', 3)->nullable();
            $table->string('email')->nullable()->index();
            $table->string('name')->nullable()->index();
            $table->string('contact_number')->nullable()->index();
            $table->text('data')->nullable();
            $table->dateTime('confirmed_at')->nullable()->index();
            $table->dateTime('confirmation_sent_at')->nullable()->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reservations');
    }
};
