<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('keyloop_lease_colours', function (Blueprint $table) {
            // add columns in this order so we end up with columns: colour_code, hex_code, gradient_hex_code
            $table->string('gradient_hex_code', 8)->nullable()->after('colour_code');
            $table->string('hex_code', 8)->nullable()->after('colour_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('keyloop_lease_colours', function (Blueprint $table) {
            $table->dropColumn([
                'gradient_hex_code',
                'hex_code',
            ]);
        });
    }
};
