<?php

namespace Mtc\MercuryDataModels\Filters;

use App\Facades\Settings;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferMakeFilter extends MakeFilter
{
    /**
     * Get available results of this filter type
     *
     * @param \Closure $product_filtering
     * @param int $limit
     * @param array $selections
     * @return Collection
     */
    public function getResults(\Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        $results = VehicleOffer::query()
            ->distinct()
            ->when(Settings::get('filter-apply-selections-to-results'), fn($query) => $query->where($product_filtering))
            ->pluck('make_id');

        return VehicleMake::query()
            ->with('filterIndex')
            ->whereIn('id', $results)
            ->orderBy('name')
            ->distinct()
            ->get();
    }
}
