<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LeaseVehicleLabel extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'lease_vehicle_labels';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'vehicle_id',
        'label_id',
        'order',
    ];

    /**
     * Relationship with Vehicle
     *
     * @return BelongsTo
     */
    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(KeyloopLeaseVehicleVariant::class, 'vehicle_id');
    }
}
