<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_bookings', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->index();
            $table->foreignId('customer_id')->nullable();
            $table->string('registration_number', 20)->index();
            $table->integer('mileage');
            $table->string('email')->nullable()->index();
            $table->string('phone_number', 50)->nullable()->index();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->dateTime('booking_time')->nullable()->index();
            $table->foreignId('location_id')->nullable()->index();
            $table->text('vehicle_data')->nullable();
            $table->text('data')->nullable();
            $table->string('notes')->nullable();
            $table->foreignId('delivery_option_id')->nullable();
            $table->string('status')->default('pending')->index();
            $table->timestamps();
        });

        Schema::create('service_booking_packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id')->index();
            $table->foreignId('package_id')->index();
            $table->timestamps();
        });

        Schema::create('service_packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('applicable_make_id')->index()->nullable();
            $table->foreignId('applicable_model_id')->index()->nullable();
            $table->string('type', 12)->index();
            $table->string('name');
            $table->decimal('price')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });

        Schema::create('service_delivery_options', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('price')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_booking_tables');
    }
};
