<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (
            Schema::hasColumn('vehicle_makes', 'cars') === false
            && Schema::hasColumn('vehicle_makes', 'lcvs') === false
            && Schema::hasColumn('vehicle_makes', 'motorcycles') === false
        ) {
            Schema::table('vehicle_makes', function (Blueprint $table) {
                $table->boolean('cars')->default(0)->index();
                $table->boolean('lcvs')->default(0)->index();
                $table->boolean('motorcycles')->default(0)->index();
            });
        }

        if (Schema::hasColumn('body_styles', 'type') === false) {
            Schema::table('body_styles', function (Blueprint $table) {
                $table->string('type')->nullable()->index();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_makes', function (Blueprint $table) {
            $table->dropColumn([
                'cars',
                'lcvs',
                'motorcycles',
            ]);
        });

        Schema::table('body_styles', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
};
