<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('content_elements', function (Blueprint $table) {
            $table->boolean('drag_and_drop')->default(0)->index()->after('is_enabled');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('content_elements', function (Blueprint $table) {
            $table->dropColumn('drag_and_drop');
        });
    }
};
