<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('new_cars', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->nullable()->index();
            $table->string('status')->nullable()->index();
            $table->boolean('featured')->index()->default(0);
            $table->boolean('published')->default(0)->index();
            $table->string('type')->index()->nullable();
            $table->string('derivative')->nullable();
            $table->foreignId('template_id')->nullable()->index();
            $table->foreignId('dealership_id')->nullable()->index();
            $table->foreignId('make_id')->nullable()->index();
            $table->foreignId('model_id')->nullable()->index();
            $table->foreignId('form_id')->nullable()->index();
            $table->decimal('price')->nullable();
            $table->decimal('deposit')->nullable();
            $table->dateTime('published_at')->nullable()->index();
            $table->text('seo')->nullable();
            $table->text('data')->nullable();
            $table->text('search_content')->nullable();

            $table->unsignedBigInteger('transmission_id')->index()->nullable();
            $table->unsignedBigInteger('fuel_type_id')->index()->nullable();
            $table->unsignedBigInteger('body_style_id')->index()->nullable();
            $table->unsignedBigInteger('drivetrain_id')->index()->nullable();
            $table->unsignedInteger('engine_size_cc')->nullable()->index();
            $table->string('colour')->nullable()->index();
            $table->foreignId('franchise_id')->nullable()->index();
            $table->foreignId('type_id')->nullable()->index();

            $table->timestamps();
            $table->softDeletes();
            if (app()->runningUnitTests() === false) {
                $table->fullText('search_content');
            }
        });

        Schema::create('new_car_content', function (Blueprint $table) {
            $table->id();
            $table->foreignId('car_id')->index();
            $table->foreignId('parent_id')->nullable()->index();
            $table->foreignId('template_element_id')->nullable()->index();
            $table->foreignId('global_content_id')->nullable()->index();
            $table->foreignId('element_id')->nullable()->index();
            $table->string('slug')->nullable()->index();
            $table->string('name')->nullable();
            $table->mediumText('content')->nullable();
            $table->text('search_content')->nullable();
            $table->mediumText('data')->nullable();
            $table->unsignedInteger('order')->default(0)->index();
            $table->timestamps();
        });

        Schema::create('new_car_content_history', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->index();
            $table->foreignId('car_id')->index();
            $table->foreignId('author_id')->nullable()->index();
            $table->boolean('is_active')->index();
            $table->boolean('pending_review')->nullable()->index();
            $table->boolean('request_changes')->nullable()->index();
            $table->mediumText('data')->nullable();
            $table->mediumText('content')->nullable();
            $table->timestamps();
            $table->softDeletes()->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('new_cars');
        Schema::dropIfExists('new_car_content');
        Schema::dropIfExists('new_car_content_history');
    }
};
