<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('seo_data', function (Blueprint $table) {
            $table->string('keywords')->nullable()->after('description');
            $table->string('index_follow')->nullable()->after('canonical');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('seo_data', function (Blueprint $table) {
            $table->dropColumn(['keywords', 'index_follow']);
        });
    }
};
