<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->float('value_float')->nullable()->change();
            $table->integer('value_integer')->nullable()->index()->after('value_float');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->integer('value_float')->nullable()->change();
            $table->dropColumn('value_integer');
        });
    }
};
