<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_notifications', function (Blueprint $table) {
            $table->id();
            $table->string('provider', 60)->index();
            $table->boolean('processed')->nullable()->index();
            $table->string('data_model', 60)->nullable()->index();
            $table->string('reference', 80)->nullable()->index();
            $table->text('headers')->nullable();
            $table->mediumText('data')->nullable();
            $table->timestamps();
            $table->index('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_notifications');
    }
};
