<?php

namespace Mtc\MercuryDataModels\Traits;

use Illuminate\Database\Eloquent\Builder;
use Mtc\MercuryDataModels\User;

trait DealershipAccessScope
{
    /**
     * Scope query to only include dealerships the user has access to.
     *
     * @param Builder $query
     * @param User|null $user User to check access for, defaults to authenticated user
     */
    public function scopeForUser(Builder $query, ?User $user = null): void
    {
        $user = $user ?? auth()->user();

        if (!$user) {
            $query->whereRaw('1 = 0');
            return;
        }

        // Admins see everything
        if ($user->hasRole(['mtc', 'Administrator'])) {
            return;
        }

        // Restricted users only see their assigned dealerships
        $query->whereIn('id', $user->getAccessibleDealershipIds());
    }
}
