<?php

namespace Mtc\MercuryDataModels\Traits;

use App\Facades\Settings;

trait FormatAsCurrency
{
    public function asCurrency(float $value, ?string $currency = null, int $decimals = 0)
    {
        $formatter = (new \NumberFormatter('en-GB', \NumberFormatter::CURRENCY));
        $formatter->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, $decimals);
        return $formatter->formatCurrency($value, $currency ?? Settings::get('app-details-currency'));
    }
}
