<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('import_conditions', function (Blueprint $table) {
            $table->id();
            $table->string('provider')->index()->nullable();
            $table->foreignId('import_map_id')->index()->nullable();
            $table->boolean('active')->index()->nullable();
            $table->boolean('do_not_import')->nullable();
            $table->boolean('do_not_publish')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::create('import_condition_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('import_condition_id')->index();
            $table->string('field');
            $table->string('condition', 30)->nullable();
            $table->string('value');
            $table->text('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('import_conditions');
        Schema::dropIfExists('import_condition_rules');
    }
};
