<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('form_activity', function (Blueprint $table) {
            $table->id();
            $table->string('form_id')->nullable()->index();
            $table->date('date')->index();
            $table->unsignedInteger('total_submissions')->default(0);
            $table->unsignedInteger('success_count')->default(0);
            $table->unsignedInteger('validation_error_count')->default(0);
            $table->unsignedInteger('failure_count')->default(0);
            $table->timestamps();

            $table->unique(['form_id', 'date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('form_activity');
    }
};
