<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('taxonomy_mapables', function (Blueprint $table) {
            $table->id();
            $table->string('tenant');
            $table->foreignId('taxonomy_map_id')
                ->constrained('taxonomy_map')
                ->onDelete('cascade')
                ->index();
            $table->morphs('mappable');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('taxonomy_mapables');
    }
};
