<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_offer_finance', function (Blueprint $table) {
            $table->id();
            $table->foreignId('offer_id')->index();
            $table->string('provider')->nullable()->index();
            $table->string('type', 5)->nullable()->index();
            $table->decimal('first_monthly', 12)->nullable();
            $table->decimal('monthly_payment', 12)->nullable();
            $table->decimal('final_payment', 12)->nullable();
            $table->decimal('full_price', 12)->nullable();
            $table->decimal('deposit', 12)->nullable();
            $table->decimal('total_amount', 12)->nullable();
            $table->decimal('total_credit_amount', 12)->nullable();
            $table->decimal('apr', 5)->nullable();
            $table->decimal('interest_rate', 5)->nullable();
            $table->smallInteger('number_of_months')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_offer_finance');
    }
};
