<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('content_element_fields', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('field_type');
        });

        Schema::table('page_content', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('element_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('content_element_fields', function (Blueprint $table) {
            $table->dropColumn('slug');
        });

        Schema::table('page_content', function (Blueprint $table) {
            $table->dropColumn('slug');
        });
    }
};
