<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->string('cta_button1_label')->nullable();
            $table->string('cta_button1_url')->nullable();
            $table->string('cta_button2_label')->nullable();
            $table->string('cta_button2_url')->nullable();
            $table->text('footnote')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn('cta_button1_label');
            $table->dropColumn('cta_button1_url');
            $table->dropColumn('cta_button2_label');
            $table->dropColumn('cta_button2_url');
            $table->dropColumn('footnote');
        });
    }
};
