<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('enquiry_answers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('enquiry_id')->index()->constrained()->cascadeOnDelete();
            $table->unsignedBigInteger('question_id')->nullable()->index();
            $table->string('question_name');
            $table->text('answer_value')->nullable();
            $table->json('answer_array')->nullable();
            $table->string('answer_type')->default('text');
            $table->timestamps();

            $table->index(['enquiry_id', 'question_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('enquiry_answers');
    }
};
