<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CarConfiguratorCustomSectionFactory;

class CarConfiguratorCustomSection extends Model
{
    use HasFactory;
    use HasMedia;
    use SoftDeletes;

    protected $table = 'car_configurator_custom_sections';

    protected $fillable = [
        'model_id',
        'section_id',
        'name',
        'description',
        'price',
        'hex',
        'hex_gradient',
        'order',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return CarConfiguratorCustomSectionFactory::new();
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(CarConfiguratorModel::class, 'model_id');
    }

    public function section(): BelongsTo
    {
        return $this->belongsTo(CarConfiguratorSection::class, 'section_id');
    }

    public function restrictions(): MorphMany
    {
        return $this->morphMany(CarConfiguratorRestriction::class, 'functionality');
    }
}
