<?php

namespace Mtc\MercuryDataModels\Factories;

use Mtc\MercuryDataModels\CatalogOffer;

class CatalogOfferFactory extends \Mtc\ContentManager\Factories\PageFactory
{
    protected $model = CatalogOffer::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'name' => $this->faker->word(),
            'subtitle' => $this->faker->word(),
            'link' => $this->faker->url,
            'button_text' => $this->faker->word(),
            'active' => $this->faker->boolean,
            'type' => CatalogOffer::TYPE_VEHICLE,
        ];
    }

    public function forVehicles(): static
    {
        return $this->state(fn(array $attributes) => [
            'type' => CatalogOffer::TYPE_VEHICLE,
        ]);
    }

    public function forNewCars(): static
    {
        return $this->state(fn(array $attributes) => [
            'type' => CatalogOffer::TYPE_NEW_CAR,
        ]);
    }
}
