<?php

namespace Mtc\MercuryDataModels;

use App\Facades\Settings;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\ContentManager\Traits\ModelSortAndFilter;
use Mtc\MercuryDataModels\Factories\FranchiseFactory;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use OwenIt\Auditing\Contracts\Auditable;

class Franchise extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use ModelSortAndFilter;
    use HasFactory;
    use HasMedia;
    use EnsuresSlug;

    protected $fillable = [
        'name',
        'slug',
        'make_id',
        'data',
        'logo',
        'primary_colour',
        'secondary_colour',
    ];

    protected $casts = [
        'data' => 'array'
    ];

    protected static function boot()
    {
        parent::boot();
        self::creating(fn (self $franchise) => $franchise->ensureSlug());
    }

    public function menus(): HasMany
    {
        return $this->hasMany(Menu::class, 'franchise_id');
    }

    public function make(): BelongsTo
    {
        return $this->belongsTo(VehicleMake::class, 'make_id');
    }


    public function pages(): HasMany
    {
        return $this->hasMany(Page::class, 'franchise_id');
    }

    public function dealerships(): HasMany|BelongsToMany
    {
        if (Settings::get('dealerships-multiple-franchises')) {
            return $this->belongsToMany(Dealership::class, 'dealership_franchises');
        }
        return $this->hasMany(Dealership::class, 'franchise_id');
    }

    public function newCars(): HasMany
    {
        return $this->hasMany(NewCar::class, 'franchise_id');
    }

    public function offers(): HasMany
    {
        return $this->hasMany(VehicleOffer::class, 'franchise_id');
    }

    public function labels(): HasMany
    {
        return $this->hasMany(Label::class, 'franchise_id');
    }

    protected static function newFactory()
    {
        return FranchiseFactory::new();
    }
}
