<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->string('name')->index();
            $table->string('type')->index();
            $table->boolean('active')->default(0)->index();
            $table->string('schedule', 30)->nullable();
            $table->string('format', 30)->nullable();
            $table->string('recipient')->nullable();
            $table->text('columns')->nullable();
            $table->text('conditions')->nullable();
            $table->dateTime('last_report_sent_at')->nullable()->index();
            $table->dateTime('next_report_due_at')->nullable()->index();
            $table->timestamps();
            $table->index('created_at');
        });

        Schema::create('report_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('report_id')->index();
            $table->boolean('succeeded')->index();
            $table->string('details')->nullable();
            $table->timestamps();
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reports');
        Schema::dropIfExists('report_logs');
    }
};
