<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use OwenIt\Auditing\Contracts\Auditable;

class BookingAvailabilityHoliday extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;

    protected $table = 'service_location_availability_holidays';

    protected $fillable = [
        'availability_id',
        'holiday_date',
        'note'
    ];

    public function availability(): BelongsTo
    {
        return $this->belongsTo(BookingAvailability::class, 'availability_id');
    }
}
