<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\CarConfiguratorModel;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\ColourMap>
 */
class CarConfiguratorModelFactory extends Factory
{
    protected $model = CarConfiguratorModel::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->word,
            'slug' => $this->faker->word(),
            'make_id' => random_int(1, 100),
            'model_id' => random_int(1, 100),
            'active' => $this->faker->boolean(),
        ];
    }
}
