<?php

namespace Mtc\MercuryDataModels\Leasing;

use App\Facades\Settings;
use Mtc\MercuryDataModels\Leasing\Contracts\LeaseVariantMonthlyPrice;

class KearysLeaseFinanceCalculator extends KeyloopLeaseFinanceCalculator
{
    /**
     * Calculations MUST be assumed to be STRICTLY CONFIDENTIAL.
     * Clients must provide the calculation that they wish to use.
     *
     * @param KeyloopFinanceRequest $request
     * @return array|int[]
     */
    protected function calculateFinance(KeyloopFinanceRequest $request): LeaseVariantMonthlyPrice
    {
        // percentage in decimal. 7% == 0.07.
        // allow VAT to be optionally specified.
        $vat_as_decimal = $request->vat_as_decimal ?? Settings::get('leasing-keyloop-fleet-kompact-vat-rate');

        // percentage in decimal. 7% == 0.07
        $interest_rate_as_decimal = Settings::get('leasing-keyloop-fleet-kompact-interest-rate');

        $monthly_charge_rate = round($interest_rate_as_decimal / 12.00, 4, PHP_ROUND_HALF_UP);

        $discount_factor = 1.00 - $monthly_charge_rate;

        // payments in advance is the deposit in months of rent
        $payments_in_advance = $request->deposit_months;

        $discount_factor_to_power_contract_length = pow($discount_factor, $request->contract_length_months);

        $sum_of_discount_factors = round(
            (
                (
                    $discount_factor * (
                        1.00 - pow($discount_factor, $request->contract_length_months - $request->deposit_months)
                    )
                ) / $monthly_charge_rate
            ),
            2,
            PHP_ROUND_HALF_UP
        );

        $imputed_months = $payments_in_advance + $sum_of_discount_factors;

        $selling_price_ex_vat_ex_vrt = $request->item_price_ex_vat_ex_vrt;

        $vrt = $request->vrt;

        $selling_price_ex_vat = $selling_price_ex_vat_ex_vrt + $vrt;

        // percentage in decimal. 7% == 0.07
        $discount_percentage_as_decimal = $request->discount_percentage_as_decimal;

        $discount_value = $selling_price_ex_vat * $discount_percentage_as_decimal;

        $bonus_value = $request->bonus_value;
        $electric_grant = $request->electric_grant;
        $delivery_price = $request->delivery_price;

        $amount_financed = $selling_price_ex_vat - $discount_value - $bonus_value - $electric_grant + $delivery_price;

        $residual_value_ex_vat = $request->residual_value_ex_vat;

        $discounted_residual_value = $residual_value_ex_vat * $discount_factor_to_power_contract_length;

        $calculated_value = $amount_financed - $discounted_residual_value;

        $monthly_rental_ex_vat = $calculated_value / $imputed_months;

        $monthly_rental_inc_vat = $monthly_rental_ex_vat * (1.00 + $vat_as_decimal);

        return new LeaseVariantMonthlyPrice(
            round($monthly_rental_ex_vat, 2),
            round($monthly_rental_inc_vat, 2),
        );
    }
}
