<?php

namespace Mtc\MercuryDataModels\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\QueueProcessLog;

class RepeatedProcessFailureMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    public function __construct(public readonly QueueProcessLog $processLog)
    {
    }

    public function envelope(): Envelope
    {
        $tenant = $this->processLog->metadata['tenant'] ?? 'unknown';
        $processType = ucwords(str_replace('_', ' ', $this->processLog->process_type));
        $provider = $this->processLog->provider ?? 'Unknown Provider';

        return new Envelope(
            subject: "[Alert] Repeated {$processType} failures for {$provider} ({$tenant})",
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.alerts.repeated-process-failure',
            with: [
                'processLog' => $this->processLog,
                'tenant' => $this->processLog->metadata['tenant'] ?? 'unknown',
                'processType' => ucwords(str_replace('_', ' ', $this->processLog->process_type)),
                'provider' => $this->processLog->provider ?? 'Unknown Provider',
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
