<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VehiclePriceHistory extends Model
{
    use HasFactory;

    protected $table = 'vehicle_price_history';

    protected $fillable = [
        'vehicle_id',
        'price',
    ];

    /**
     * Relationship with Vehicle
     *
     * @return BelongsTo
     */
    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_id');
    }
}
