<?php

namespace Mtc\MercuryDataModels\Factories;

use App\Tier;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Franchise;
use Mtc\MercuryDataModels\Tenant;

class FranchiseFactory extends Factory
{
    protected $model = Franchise::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->sentence(),
            'slug' => Str::slug($this->faker->sentence()),
            'make_id' => random_int(1, 10),
            'data' => [],
            'logo' => $this->faker->word(),
        ];
    }
}
