<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\VehicleReview;

class VehicleReviewFactory extends Factory
{
    protected $model = VehicleReview::class;

    public function definition()
    {
        return [
            'external_review_id' => $this->faker->uuid(),
            'provider' => 'abc',
            'meta' => json_encode([
                'review_type' => $this->faker->randomElement(['new2', 'new1', 'used']),
                'status' => $this->faker->word(),
                'cap_id' => $this->faker->numberBetween(10000, 90000)
            ]),
            'review' => json_encode([
                [
                    "type" => "By Line",
                    "headline" => "",
                    "text" => $this->faker->sentence(),
                ],
                [
                    "type" => "Ten Second Review",
                    "headline" => "Ten Second Review",
                    "text" => $this->faker->paragraph(),
                ],
                [
                    "type" => "Background",
                    "headline" => "Background",
                    "text" => $this->faker->paragraph(5),
                ],
                [
                    "type" => "Driving Experience",
                    "headline" => "Driving Experience",
                    "text" => $this->faker->paragraph(6),
                ],
                [
                    "type" => "Design and Build",
                    "headline" => "Design and Build",
                    "text" => $this->faker->paragraph(4),
                ],
                [
                    "type" => "Market and Model",
                    "headline" => "Market and Model",
                    "text" => $this->faker->paragraph(4),
                ],
                [
                    "type" => "Cost of Ownership",
                    "headline" => "Cost of Ownership",
                    "text" => $this->faker->paragraph(4),
                ],
                [
                    "type" => "Summary",
                    "headline" => "Summary",
                    "text" => $this->faker->paragraph(2),
                ],
            ])
        ];
    }
}
