<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('body_styles', function (Blueprint $table) {
            $table->unsignedInteger('order')->index()->nullable();
        });

        Schema::table('fuel_types', function (Blueprint $table) {
            $table->unsignedInteger('order')->index()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('body_styles', function (Blueprint $table) {
            $table->dropColumn('order');
        });

        Schema::table('fuel_types', function (Blueprint $table) {
            $table->dropColumn('order');
        });
    }
};
