<?php

namespace Mtc\MercuryDataModels\Features;

use Mtc\MercuryDataModels\Contracts\FeatureFlag;
use Mtc\MercuryDataModels\Setting;
use Mtc\MercuryDataModels\VehicleMake;

class MakesPlaceholderImages extends FeatureFlag
{
    public function name(): string
    {
        return __('features.makes_placeholders.title');
    }

    public function description(): string
    {
        return __('features.makes_placeholders.description');
    }

    public static function populateSettings()
    {
        $makes = VehicleMake::query()
            ->has('vehicles')
            ->select('id', 'name')
            ->orderBy('name')
            ->get();

        foreach ($makes as $make) {
            $configKey = 'placeholder-image-vehicle-make-' . $make->id;

            Setting::firstOrCreate(
                ['config_key' => $configKey],
                [
                    'tab' => 'Site',
                    'section' => 'Content',
                    'group' => 'Placeholder Images By Makes',
                    'name' => $make->name,
                    'config_key' => $configKey,
                    'type' => 'media',
                    'value' => null,
                    'feature' => 'makes-placeholders',
                ]
            );
        }
    }
}
