<?php

namespace Mtc\MercuryDataModels\Finance;

use App\Facades\Settings;
use Mtc\MercuryDataModels\Vehicle;

class FinanceEligibilityChecker
{
    public function allowCreditRatingFinance(Vehicle $vehicle): bool
    {
        $enabled = Settings::get('finance-risk-based-pricing-enabled');
        if (!$enabled) {
            return false;
        }

        if (Settings::get('finance-use-products-risk-based-pricing')) {
            return true;
        }

        if (
            (!Settings::get('finance-risk-based-pricing-allow-electric') && $vehicle->fuelType->name === 'Electric')
            || !$this->financeOptionAllowed($vehicle->getCustom('finance_option') ?? 0)
        ) {
            return false;
        }
        return $vehicle->dealership->data['finance-risk-based-pricing'] ?? false;
    }

    private function financeOptionAllowed(int $financeOption): bool
    {
        return in_array($financeOption, explode(',', Settings::get('finance-risk-based-pricing-finance-options', '')));
    }
}
