<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_users', function (Blueprint $table) {
            $table->string('previous_client_id')->nullable()->after('client_secret');
            $table->text('previous_client_secret')->nullable()->after('previous_client_id');
            $table->dateTime('previous_credentials_expires_at')->nullable()->after('previous_client_secret');
            $table->index('previous_client_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_users', function (Blueprint $table) {
            $table->dropIndex(['previous_client_id']);
            $table->dropColumn([
                'previous_client_id',
                'previous_client_secret',
                'previous_credentials_expires_at',
            ]);
        });
    }
};
