<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('content_elements', function (Blueprint $table) {
            $table->string('preview_image')->nullable()->after('icon');
        });
        Schema::table('global_content', function (Blueprint $table) {
            $table->string('preview_image')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('content_elements', function (Blueprint $table) {
            $table->dropColumn('preview_image');
        });
        Schema::table('global_content', function (Blueprint $table) {
            $table->dropColumn('preview_image');
        });
    }
};
