<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shortcodes', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->index();
            $table->string('model')->nullable()->index();
            $table->softDeletes();
            $table->timestamps();
        });

        Schema::create('shortcode_conditions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('shortcode_id')->index();
            $table->string('column');
            $table->string('operator');
            $table->string('value');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shortcodes');
        Schema::dropIfExists('shortcode_conditions');
    }
};
