<?php

namespace Mtc\MercuryDataModels\Enums;

enum SocialMediaPlatform: string
{
    case FACEBOOK = 'facebook';
    case TWITTER = 'twitter';
    case YOUTUBE = 'youtube';
    case INSTAGRAM = 'instagram';
    case LINKEDIN = 'linkedin';
    case TIKTOK = 'tiktok';

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function label(): string
    {
        return match ($this) {
            self::FACEBOOK => 'Facebook',
            self::TWITTER => 'Twitter',
            self::YOUTUBE => 'YouTube',
            self::INSTAGRAM => 'Instagram',
            self::LINKEDIN => 'LinkedIn',
            self::TIKTOK => 'TikTok',
        };
    }
}
