<?php

namespace Mtc\MercuryDataModels\Factories;

use App\BillableType;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Billable;

class BillableFactory extends Factory
{
    protected $model = Billable::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'type' => array_rand(BillableType::cases()),
            'code' => Str::random(5),
            'name' => $this->faker->sentence(),
            'description' => $this->faker->paragraph(),
            'active' => random_int(0, 1),
            'price' => random_int(10, 5000),
        ];
    }
}
